/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
* File name     : tdecdefs.h
************************************************************************
* Written by    : Christian Zurhorst, BID R&D, 17.11.97
* Last modified : ask clearcase
************************************************************************
* File contents :
*                 own type definitions, taken out of mini_api.h 
************************************************************************
* NOTES :
************************************************************************
*/

#ifndef TDECDEFS_H_INCLUDED                               
#define TDECDEFS_H_INCLUDED


/* ---------------------------------------------------------------
 * definitions for decoders
 * --------------------------------------------------------------- */


#define B_DEC_INVALID		0xffffffffUL

/* number of decoders in the CAPI, see src/include/tdecdefs.h b_decodertype */
#define B_DECTYPE_NUM	11

CLI typedef enum {
  B_DEC_SUBTRACTIVE,			/* @subtract */
  B_DEC_STANDARD_1,			/* @std1 */
  B_DEC_STANDARD_2,			/* @std2 */
  B_DEC_STANDARD_3,			/* @std3 */
  B_DEC_STANDARD_4,			/* @std4 */
  B_DEC_STANDARD_5,			/* @std5 */
  B_DEC_STANDARD_6,			/* @std6 */
  B_DEC_EXPROM,				/* @exprom */
  B_DEC_CONFIG,				/* @config */
  B_DEC_FULL_CONFIG,			/* @fullconfig */
  B_DEC_USER_CONFIG,			/* @userconfig */
  B_DEC_NODECODER
} b_decodertype;


#define B_DECPROP_SIZE		19

CLI typedef enum {
  B_DEC_SIZE,         	/* @size */
  B_DEC_BASEADDR,     	/* @base */
  B_DEC_SPEED,        	/* @speed */
  B_DEC_MODE,         	/* @mode */
  B_DEC_LOCATION,     	/* @loc  */
  B_DEC_PREFETCH,     	/* @prefetch */
  B_DEC_BEHAVIOR,      	/* @behavior */
  B_DEC_BASEDEC,	/* @basedec */
  B_DEC_RESOURCE,	/* @res */
  B_DEC_RESBASE,	/* @resbase */
  B_DEC_RESSIZE,	/* @ressize */
  B_DEC_BUSCMD,		/* @cmd */
  B_DEC_DAC,		/* @dac */
  B_DEC_IDSEL,		/* @idsel */
  B_DEC_PRIMARY_BUS,	/* @primary */
  B_DEC_SECONDARY_BUS,	/* @secondary */
  B_DEC_MASK,		/* @mask */
  B_DEC_MASK_HI,       	/* @maskhi */
  B_DEC_BASEADDR_HI	/* @basehi */
} b_decproptype;


CLI /* DEF_START ~G_DecoderSpeed */
#define B_DSP_SLOW			0x0    	/* @slow */
#define B_DSP_MEDIUM			0x1    	/* @medium */
#define B_DSP_FAST			0x2    	/* @fast */
#define B_DSP_PROTECTEDFAST		0x3	/* @pfast */
#define B_DSP_NODEVSEL			0x4	/* @nodevsel */
CLI /* DEF_END */


CLI /* DEF_START ~G_DecoderMode */
#define B_MODE_MEM			0x0	/* @mem */
#define B_MODE_IO			0x1	/* @io */
#define B_MODE_CONFIG           	0x2	/* @config */
CLI /* DEF_END */


/* !!! Note !!!
   @io is defined here and in decoder mode but it has the same value, CZ
*/

CLI /* DEF_START ~G_DecoderLocation */
#define B_LOC_SPACE32			0x0	/* @space32 */
#define B_LOC_BELOW1MEG			0x2	/* @below1meg */
#define B_LOC_SPACE64			0x4	/* @space64 */
#define B_LOC_IO			0x1	/* @io */
CLI /* DEF_END */


/* !!! Note !!!
   @config is defined here and in decoder mode but it has the same value, CZ
*/

CLI /* DEF_START ~G_DecoderBehavior */
#define B_BEH_NORMAL			0x0	/* @normal */
#define B_BEH_OVERLAY			0x1	/* @overlay */
#define B_BEH_CONFIG			0x2	/* @config */
#define B_BEH_CUSTOM			0x3	/* @custom */
CLI /* DEF_END */


CLI /* DEF_START ~G_DecoderResource */
#define B_RES_DATA			0x0	/* @data */
#define B_RES_DATA_DEFATTR		0x1	/* @datadef */
#define B_RES_COMPARE			0x2	/* @comp */
#define B_RES_COMPARE_DEFATTR		0x3	/* @compdef */
#define B_RES_REGFILE			0x4	/* @regfile */
#define B_RES_CPUHELP			0x5	/* @cpuhelp */
#define B_RES_CPUPORT0			0x6	/* @cpuport0 */
#define B_RES_CPUPORT1		       	0x7	/* @cpuport1 */
#define B_RES_EXPROM			0x8	/* @exprom */
#define B_RES_STATIC_IO			0x9	/* @statio */
#define B_RES_INTBUS			0xa	/* @bus */
CLI /* DEF_END */


CLI /* DEF_START ~G_DecoderCommands */
#define B_CMDBIT_INTR_ACK	       	0x0001 /* @d_int_ack */            
#define B_CMDBIT_SPECIAL	       	0x0002 /* @d_special */            
#define B_CMDBIT_IO_READ	       	0x0004 /* @d_io_read */            
#define B_CMDBIT_IO_WRITE	       	0x0008 /* @d_io_write */           
#define B_CMDBIT_RESERVED_4		0x0010 /* @d_reserved_4 */         
#define B_CMDBIT_RESERVED_5		0x0020 /* @d_reserved_5 */         
#define B_CMDBIT_MEM_READ	       	0x0040 /* @d_mem_read */           
#define B_CMDBIT_MEM_WRITE	       	0x0080 /* @d_mem_write */          
#define B_CMDBIT_RESERVED_8		0x0100 /* @d_reserved_8 */         
#define B_CMDBIT_RESERVED_9		0x0200 /* @d_reserved_9 */         
#define B_CMDBIT_CONFIG_READ		0x0400 /* @d_config_read */        
#define B_CMDBIT_CONFIG_WRITE		0x0800 /* @d_config_write */       
#define B_CMDBIT_MEM_READMULTIPLE      	0x1000 /* @d_mem_readmultiple */   
#define B_CMDBIT_DAC			0x2000 /* @d_dac */
#define B_CMDBIT_MEM_READLINE		0x4000 /* @d_mem_readline */       
#define B_CMDBIT_MEM_WRITEINVALIDATE	0x8000 /* @d_mem_writeinvalidate */
CLI /* DEF_END */


CLI /* DEF_START ~G_DecoderDAC */
#define B_DAC_YES			0x1	/* @yes */
#define B_DAC_NO			0x0	/* @no */
#define B_DAC_BOTH			0x2	/* @both */
CLI /* DEF_END */


CLI /* DEF_START ~G_DecoderIdsel */
#define B_IDSEL_ASSERT			0x1	/* @assert */
#define B_IDSEL_DEASSERT		0x0	/* @deassert */
#define B_IDSEL_DONTCARE		0x2	/* @dontcare */
CLI /* DEF_END */


#endif
